function stk = stk_filter(stk,varargin);
%A function that will allow the user to quickly filter a stack of images 
%using a variety of filter methods
%Synatax: stk_out = stk_filter(stk_in,'filter type1',[parameters],...);
%Input:     stk = the name of the image stack.
%           Filter type = The type of filter desired.  Parameters are
%           optional, default will be used if the user does not specify.
%           Multiple filters can be applied to the same image stack, the
%           entered order will be the order that the filters are applied to
%           the image stack.
%           The filter types currenly accepted are:
%           'median' = parameters: m,n 'neighbor size' Default = [2 2].  It
%           is also the Default filter.
%           'manual' = uses imfilter for the filtering operation.
%           'range_ext' = Streches the full dynamic range of the image.
%           parameters: new_lim, old_lim, if no arguments enter [].
%           'adpative' = An adaptive filter that is best for gausian noise.
%           Default = [2 2]
%Output:    stk = the processed image stack.
%Note: the order you enter the filters into the function will be the order
%the filters are applied to the stack.

filters = [];   %filters structure is used to hold the information pertinent to the filtering of the stack
flt_cnt = 0;   %filter count
param_cnt = 0;  %parameter count

if ~isempty(varargin) %there are inputs parse
    for i = 1:size(varargin,2)      %step through all inputs
        try     %try and catch the inevitable error that will occur when a manual filter is thrown in to the switch.
            switch varargin{1,i}
                case 'median'
                    if isempty(filters)
                        filters(1).type = 'median';
                    else
                        filters(flt_cnt+1).type = 'median';
                    end
                    flt_cnt = flt_cnt+1;
                    param_cnt = 0;  %parameter count
                    filters(flt_cnt).parameter_num = param_cnt; %default to zero
                case 'manual'
                    if isempty(filters)
                        filters(1).type = 'manual';
                    else
                        filters(flt_cnt+1).type = 'manual';
                    end
                    flt_cnt = flt_cnt+1;
                    param_cnt = 0;  %parameter count
                    filters(flt_cnt).parameter_num = param_cnt; %default to zero
                case 'range_ext'
                    if isempty(filters)
                        filters(1).type = 'range_ext';
                    else
                        filters(flt_cnt+1).type = 'range_ext';
                    end
                    flt_cnt = flt_cnt+1;
                    param_cnt = 0;  %parameter count
                    filters(flt_cnt).parameter_num = param_cnt; %default to zero
                case 'adaptive'
                    if isempty(filters)
                        filters(1).type = 'adaptive';
                    else
                        filters(flt_cnt+1).type = 'adaptive';
                    end
                    flt_cnt = flt_cnt+1;
                    param_cnt = 0;  %parameter count
                    filters(flt_cnt).parameter_num = param_cnt; %default to zero
                otherwise
                    param_cnt = param_cnt+1;
                    filters(flt_cnt).parameter{1,param_cnt} = varargin{1,i};
                    filters(flt_cnt).parameter_num = param_cnt; 
            end
        catch   %filter - We understand.
            param_cnt = param_cnt+1;
            filters(flt_cnt).parameter{1,param_cnt} = varargin{1,i};
            filters(flt_cnt).parameter_num = param_cnt; 
        end
    end
else    %no parameters entered: default to median
    flt_cnt = 1;
    param_cnt = 1;
    filters(1).type = 'median';
    filters(1).parameter{1,1} = [2 2];
    filters(1).parameter_num = 1;
end

%filter the stack
for i = 1:flt_cnt   %go through all of the filters
    switch filters(i).type
        case 'median'
            if filters(i).parameter_num~=0       %there are parameters
                %You know what, this is going to be used with the gui and
                %there is no reason to make it so flexible as to try to
                %figure out odd user parameter entries.  Thus comment this
                %out and go for simplicity.
%                 for j = 1:filter(i).parameter_num
%                     if isnumeric(filters(i).parameter{1,j}
%                         neighbor = filters(i).parameter{1,j};
%                     else
%                         error(['Error: the median filter only take a numeric input [x y]']);
%                     end
%                 end
                if isnumeric(filters(i).parameter{1,1}) && filters(i).parameter_num==1
                    neighbor = filters(i).parameter{1,1};
                else
                    error(['Error: Median filter takes only one parameter [x y] that denotes',...
                        ' the the x by y pixel neighborhood over which it filters.']);
                end
            else    %no parameters: Default
                neighbor = [2 2];
            end
            %filter the stack
            h = waitbar(0,'Median Filter(Frame#): 0 ...Processed.');         %create progress bar
            for j = 1:size(stk,3)
                stk(:,:,j) = medfilt2(stk(:,:,j),neighbor);
                %display to user filter progress
                %disp(['Median Filter(Frame #): ',num2str(j), '...Processed.']);
                waitbar(j/size(stk,3),h,['Median Filter(Frame#): ',num2str(j),' ...Processed.']);   %show progress
            end
            close(h)    %close progress bar
            %show user we are done
            %disp('Median Filter Done.');
        case 'adaptive'
            if filters(i).parameter_num~=0       %there are parameters
                if isnumeric(filters(i).parameter{1,1}) && filters(i).parameter_num==1
                    neighbor = filters(i).parameter{1,1};
                else
                    error(['Error: Adaptive filter takes only one parameter [x y] that denotes',...
                        ' the the x by y pixel neighborhood over which it filters.']);
                end
            else    %no parameters: Default
                neighbor = [2 2];
            end
            %filter the stack
            h = waitbar(0,'Adaptive Filter(Frame#): 0 ...Processed.');         %create progress bar
            for j = 1:size(stk,3)
                stk(:,:,j) = wiener2(stk(:,:,j),neighbor);
                %disp(['Adaptive Filter(Frame #): ',num2str(j), '...Processed.']);
                waitbar(j/size(stk,3),h,['Adaptive Filter(Frame#): ',num2str(j),' ...Processed.']);   %show progress
            end
            close(h)    %close progress bar
            %disp('Adaptive Filter Done.');
        case 'range_ext'
            if filters(i).parameter_num~=0       %there are parameters
                if filters(i).parameter_num==2
                    new_lim = filters(i).parameter{1,1};
                    old_lim = filters(i).parameter{1,2};
                else
                    error(['Error: Range extend takes only 2 parameters old lim and new lim that denotes',...
                        ' old maximum pixel value and the new manimum pixel value']);
                end
            else    %no parameters: Default
                new_lim = 256;
                old_lim = max(max(max(stk)));
            end
            h = waitbar(0,'Adaptive Filter(Frame#): 0 ...Processed.');         %create progress bar
            for j = 1:size(stk,3)
                stk(:,:,j) = rangemax(stk(:,:,j),new_lim,old_lim);
                %disp(['Range Extend(Frame #): ',num2str(j), '...Processed.']);
                waitbar(j/size(stk,3),h,['Adaptive Filter(Frame#): ',num2str(j),' ...Processed.']);   %update progress
            end
            close(h);
            %disp('Range Extend Done.');
        case 'manual'
            if filters(i).parameter_num~=0       %there are parameters
                if filters(i).parameter_num==4
                    filter = filters(i).parameter{1,1};
                    boundary = filters(i).parameter{1,2};
                    output = filters(i).parameter{1,3};
                    operation = filters(i).parameter{1,4};
                else
                    error(['Error: manual filtering uses syntax as such: ',...
                        'filter,boundary,output,type of operation.  If you need more info look up imfilter.']);
                end
            else
                filter = fspecial('gaussian',[3 3],0.5);
                boundary = 'symmetric';
                output = 'same';
                operation = 'corr';
            end
            h = waitbar(0,'Adaptive Filter(Frame#): 0 ...Processed.');         %create progress bar
            for j = 1:size(stk,3)
                stk(:,:,j) = imfilter(stk(:,:,j),filter,boundary,output,operation);
                %disp(['Manual Filter(Frame #): ',num2str(j), '...Processed.']);
                waitbar(j/size(stk,3),h,['Adaptive Filter(Frame#): ',num2str(j),' ...Processed.']);   %update progress
            end
            close(h);
            %disp('Manual Filter Done.');
    end
end